<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentCreditNoteRequestBankAccount extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $bicSwift;

    /**
     * @var string
     */
    protected $iban;

    /**
     * @var string|null
     */
    protected $filledMandateValidatedDate;

    /**
     * @var string
     */
    protected $identityName;

    /**
     * @var string|null
     */
    protected $rum;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getBicSwift(): ?string
    {
        return $this->bicSwift;
    }

    public function setBicSwift(?string $bicSwift): self
    {
        $this->initialized['bicSwift'] = true;
        $this->bicSwift = $bicSwift;

        return $this;
    }

    public function getIban(): string
    {
        return $this->iban;
    }

    public function setIban(string $iban): self
    {
        $this->initialized['iban'] = true;
        $this->iban = $iban;

        return $this;
    }

    public function getFilledMandateValidatedDate(): ?string
    {
        return $this->filledMandateValidatedDate;
    }

    public function setFilledMandateValidatedDate(?string $filledMandateValidatedDate): self
    {
        $this->initialized['filledMandateValidatedDate'] = true;
        $this->filledMandateValidatedDate = $filledMandateValidatedDate;

        return $this;
    }

    public function getIdentityName(): string
    {
        return $this->identityName;
    }

    public function setIdentityName(string $identityName): self
    {
        $this->initialized['identityName'] = true;
        $this->identityName = $identityName;

        return $this;
    }

    public function getRum(): ?string
    {
        return $this->rum;
    }

    public function setRum(?string $rum): self
    {
        $this->initialized['rum'] = true;
        $this->rum = $rum;

        return $this;
    }
}
