<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentCreditNoteBulkRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $accountingStatus;

    /**
     * @var list<IdRequest>
     */
    protected $resources;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingStatus(): ?string
    {
        return $this->accountingStatus;
    }

    public function setAccountingStatus(?string $accountingStatus): self
    {
        $this->initialized['accountingStatus'] = true;
        $this->accountingStatus = $accountingStatus;

        return $this;
    }

    /**
     * @return list<IdRequest>
     */
    public function getResources(): array
    {
        return $this->resources;
    }

    /**
     * @param list<IdRequest> $resources
     */
    public function setResources(array $resources): self
    {
        $this->initialized['resources'] = true;
        $this->resources = $resources;

        return $this;
    }
}
