<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentAddressRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $addressSupplement;

    /**
     * @var string
     */
    protected $city;

    /**
     * Veterinary Establishment Address Country - Request Component.
     *
     * @var string
     */
    protected $country;

    /**
     * Coordinate - Request Model.
     *
     * @var CoordinateRequest|null
     */
    protected $coordinates;

    /**
     * @var string|null
     */
    protected $department;

    /**
     * @var string|null
     */
    protected $email;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var VeterinaryEstablishmentAddressRequestPhone|null
     */
    protected $phone;

    /**
     * @var string
     */
    protected $postalCode;

    /**
     * @var string|null
     */
    protected $postBoxNumber;

    /**
     * @var string|null
     */
    protected $recipientIdentity;

    /**
     * @var string|null
     */
    protected $region;

    /**
     * @var string
     */
    protected $streetName;

    /**
     * @var string|null
     */
    protected $streetNumber;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;

    /**
     * @var string|null
     */
    protected $websiteUrl;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAddressSupplement(): ?string
    {
        return $this->addressSupplement;
    }

    public function setAddressSupplement(?string $addressSupplement): self
    {
        $this->initialized['addressSupplement'] = true;
        $this->addressSupplement = $addressSupplement;

        return $this;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function setCity(string $city): self
    {
        $this->initialized['city'] = true;
        $this->city = $city;

        return $this;
    }

    /**
     * Veterinary Establishment Address Country - Request Component.
     */
    public function getCountry(): string
    {
        return $this->country;
    }

    /**
     * Veterinary Establishment Address Country - Request Component.
     */
    public function setCountry(string $country): self
    {
        $this->initialized['country'] = true;
        $this->country = $country;

        return $this;
    }

    /**
     * Coordinate - Request Model.
     */
    public function getCoordinates(): ?CoordinateRequest
    {
        return $this->coordinates;
    }

    /**
     * Coordinate - Request Model.
     */
    public function setCoordinates(?CoordinateRequest $coordinates): self
    {
        $this->initialized['coordinates'] = true;
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getDepartment(): ?string
    {
        return $this->department;
    }

    public function setDepartment(?string $department): self
    {
        $this->initialized['department'] = true;
        $this->department = $department;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->initialized['email'] = true;
        $this->email = $email;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getPhone(): ?VeterinaryEstablishmentAddressRequestPhone
    {
        return $this->phone;
    }

    public function setPhone(?VeterinaryEstablishmentAddressRequestPhone $phone): self
    {
        $this->initialized['phone'] = true;
        $this->phone = $phone;

        return $this;
    }

    public function getPostalCode(): string
    {
        return $this->postalCode;
    }

    public function setPostalCode(string $postalCode): self
    {
        $this->initialized['postalCode'] = true;
        $this->postalCode = $postalCode;

        return $this;
    }

    public function getPostBoxNumber(): ?string
    {
        return $this->postBoxNumber;
    }

    public function setPostBoxNumber(?string $postBoxNumber): self
    {
        $this->initialized['postBoxNumber'] = true;
        $this->postBoxNumber = $postBoxNumber;

        return $this;
    }

    public function getRecipientIdentity(): ?string
    {
        return $this->recipientIdentity;
    }

    public function setRecipientIdentity(?string $recipientIdentity): self
    {
        $this->initialized['recipientIdentity'] = true;
        $this->recipientIdentity = $recipientIdentity;

        return $this;
    }

    public function getRegion(): ?string
    {
        return $this->region;
    }

    public function setRegion(?string $region): self
    {
        $this->initialized['region'] = true;
        $this->region = $region;

        return $this;
    }

    public function getStreetName(): string
    {
        return $this->streetName;
    }

    public function setStreetName(string $streetName): self
    {
        $this->initialized['streetName'] = true;
        $this->streetName = $streetName;

        return $this;
    }

    public function getStreetNumber(): ?string
    {
        return $this->streetNumber;
    }

    public function setStreetNumber(?string $streetNumber): self
    {
        $this->initialized['streetNumber'] = true;
        $this->streetNumber = $streetNumber;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): IdRequest
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    public function getWebsiteUrl(): ?string
    {
        return $this->websiteUrl;
    }

    public function setWebsiteUrl(?string $websiteUrl): self
    {
        $this->initialized['websiteUrl'] = true;
        $this->websiteUrl = $websiteUrl;

        return $this;
    }
}
