<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1PetMicrochipsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var \DateTime|null
     */
    protected $date;

    /**
     * @var string|null
     */
    protected $location;

    /**
     * @var string|null
     */
    protected $number;

    /**
     * Id - Common Request Model.
     *
     * @var V1PetMicrochipsPostBodyPet
     */
    protected $pet;

    /**
     * @var string
     */
    protected $type;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getDate(): ?\DateTime
    {
        return $this->date;
    }

    public function setDate(?\DateTime $date): self
    {
        $this->initialized['date'] = true;
        $this->date = $date;

        return $this;
    }

    public function getLocation(): ?string
    {
        return $this->location;
    }

    public function setLocation(?string $location): self
    {
        $this->initialized['location'] = true;
        $this->location = $location;

        return $this;
    }

    public function getNumber(): ?string
    {
        return $this->number;
    }

    public function setNumber(?string $number): self
    {
        $this->initialized['number'] = true;
        $this->number = $number;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getPet(): V1PetMicrochipsPostBodyPet
    {
        return $this->pet;
    }

    /**
     * Id - Common Request Model.
     */
    public function setPet(V1PetMicrochipsPostBodyPet $pet): self
    {
        $this->initialized['pet'] = true;
        $this->pet = $pet;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }
}
