<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1PetBreedTagsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var int|null
     */
    protected $color;

    /**
     * Translation - Pet Breed Tag Request Model.
     *
     * @var V1PetBreedTagsPostBodyTranslations
     */
    protected $translations;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getColor(): ?int
    {
        return $this->color;
    }

    public function setColor(?int $color): self
    {
        $this->initialized['color'] = true;
        $this->color = $color;

        return $this;
    }

    /**
     * Translation - Pet Breed Tag Request Model.
     */
    public function getTranslations(): V1PetBreedTagsPostBodyTranslations
    {
        return $this->translations;
    }

    /**
     * Translation - Pet Breed Tag Request Model.
     */
    public function setTranslations(V1PetBreedTagsPostBodyTranslations $translations): self
    {
        $this->initialized['translations'] = true;
        $this->translations = $translations;

        return $this;
    }
}
