<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SupplierOrderResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string|null
     */
    protected $orderCode;

    /**
     * @var string|null
     */
    protected $billedSupplierCode;

    /**
     * @var string|null
     */
    protected $deliveredSupplierCode;

    /**
     * @var string|null
     */
    protected $deliveredSupplierName;

    /**
     * @var \DateTime|null
     */
    protected $invoiceDate;

    /**
     * @var \DateTime|null
     */
    protected $deliveryDate;

    /**
     * @var string|null
     */
    protected $type;

    /**
     * @var string|null
     */
    protected $invoiceCode;

    /**
     * @var string|null
     */
    protected $deliveryCode;

    /**
     * @var string|null
     */
    protected $productCode;

    /**
     * @var string|null
     */
    protected $productName;

    /**
     * @var float|null
     */
    protected $unitPrice;

    /**
     * @var float|null
     */
    protected $rebatedUnitPrice;

    /**
     * @var float|null
     */
    protected $taxRate;

    /**
     * @var int|null
     */
    protected $quantity;

    /**
     * @var float|null
     */
    protected $rebatedTotalPrice;

    /**
     * @var float|null
     */
    protected $weight;

    /**
     * @var float|null
     */
    protected $netWeight;

    /**
     * @var string|null
     */
    protected $gtin;

    /**
     * @var string|null
     */
    protected $class;

    /**
     * @var string|null
     */
    protected $manufacturer;

    /**
     * @var float|null
     */
    protected $totalPrice;

    /**
     * @var float|null
     */
    protected $rebatingRate;

    /**
     * @var string
     */
    protected $veterinaryEstablishmentId;

    /**
     * @var string
     */
    protected $supplier;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getOrderCode(): ?string
    {
        return $this->orderCode;
    }

    public function setOrderCode(?string $orderCode): self
    {
        $this->initialized['orderCode'] = true;
        $this->orderCode = $orderCode;

        return $this;
    }

    public function getBilledSupplierCode(): ?string
    {
        return $this->billedSupplierCode;
    }

    public function setBilledSupplierCode(?string $billedSupplierCode): self
    {
        $this->initialized['billedSupplierCode'] = true;
        $this->billedSupplierCode = $billedSupplierCode;

        return $this;
    }

    public function getDeliveredSupplierCode(): ?string
    {
        return $this->deliveredSupplierCode;
    }

    public function setDeliveredSupplierCode(?string $deliveredSupplierCode): self
    {
        $this->initialized['deliveredSupplierCode'] = true;
        $this->deliveredSupplierCode = $deliveredSupplierCode;

        return $this;
    }

    public function getDeliveredSupplierName(): ?string
    {
        return $this->deliveredSupplierName;
    }

    public function setDeliveredSupplierName(?string $deliveredSupplierName): self
    {
        $this->initialized['deliveredSupplierName'] = true;
        $this->deliveredSupplierName = $deliveredSupplierName;

        return $this;
    }

    public function getInvoiceDate(): ?\DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getDeliveryDate(): ?\DateTime
    {
        return $this->deliveryDate;
    }

    public function setDeliveryDate(?\DateTime $deliveryDate): self
    {
        $this->initialized['deliveryDate'] = true;
        $this->deliveryDate = $deliveryDate;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getInvoiceCode(): ?string
    {
        return $this->invoiceCode;
    }

    public function setInvoiceCode(?string $invoiceCode): self
    {
        $this->initialized['invoiceCode'] = true;
        $this->invoiceCode = $invoiceCode;

        return $this;
    }

    public function getDeliveryCode(): ?string
    {
        return $this->deliveryCode;
    }

    public function setDeliveryCode(?string $deliveryCode): self
    {
        $this->initialized['deliveryCode'] = true;
        $this->deliveryCode = $deliveryCode;

        return $this;
    }

    public function getProductCode(): ?string
    {
        return $this->productCode;
    }

    public function setProductCode(?string $productCode): self
    {
        $this->initialized['productCode'] = true;
        $this->productCode = $productCode;

        return $this;
    }

    public function getProductName(): ?string
    {
        return $this->productName;
    }

    public function setProductName(?string $productName): self
    {
        $this->initialized['productName'] = true;
        $this->productName = $productName;

        return $this;
    }

    public function getUnitPrice(): ?float
    {
        return $this->unitPrice;
    }

    public function setUnitPrice(?float $unitPrice): self
    {
        $this->initialized['unitPrice'] = true;
        $this->unitPrice = $unitPrice;

        return $this;
    }

    public function getRebatedUnitPrice(): ?float
    {
        return $this->rebatedUnitPrice;
    }

    public function setRebatedUnitPrice(?float $rebatedUnitPrice): self
    {
        $this->initialized['rebatedUnitPrice'] = true;
        $this->rebatedUnitPrice = $rebatedUnitPrice;

        return $this;
    }

    public function getTaxRate(): ?float
    {
        return $this->taxRate;
    }

    public function setTaxRate(?float $taxRate): self
    {
        $this->initialized['taxRate'] = true;
        $this->taxRate = $taxRate;

        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $quantity): self
    {
        $this->initialized['quantity'] = true;
        $this->quantity = $quantity;

        return $this;
    }

    public function getRebatedTotalPrice(): ?float
    {
        return $this->rebatedTotalPrice;
    }

    public function setRebatedTotalPrice(?float $rebatedTotalPrice): self
    {
        $this->initialized['rebatedTotalPrice'] = true;
        $this->rebatedTotalPrice = $rebatedTotalPrice;

        return $this;
    }

    public function getWeight(): ?float
    {
        return $this->weight;
    }

    public function setWeight(?float $weight): self
    {
        $this->initialized['weight'] = true;
        $this->weight = $weight;

        return $this;
    }

    public function getNetWeight(): ?float
    {
        return $this->netWeight;
    }

    public function setNetWeight(?float $netWeight): self
    {
        $this->initialized['netWeight'] = true;
        $this->netWeight = $netWeight;

        return $this;
    }

    public function getGtin(): ?string
    {
        return $this->gtin;
    }

    public function setGtin(?string $gtin): self
    {
        $this->initialized['gtin'] = true;
        $this->gtin = $gtin;

        return $this;
    }

    public function getClass(): ?string
    {
        return $this->class;
    }

    public function setClass(?string $class): self
    {
        $this->initialized['class'] = true;
        $this->class = $class;

        return $this;
    }

    public function getManufacturer(): ?string
    {
        return $this->manufacturer;
    }

    public function setManufacturer(?string $manufacturer): self
    {
        $this->initialized['manufacturer'] = true;
        $this->manufacturer = $manufacturer;

        return $this;
    }

    public function getTotalPrice(): ?float
    {
        return $this->totalPrice;
    }

    public function setTotalPrice(?float $totalPrice): self
    {
        $this->initialized['totalPrice'] = true;
        $this->totalPrice = $totalPrice;

        return $this;
    }

    public function getRebatingRate(): ?float
    {
        return $this->rebatingRate;
    }

    public function setRebatingRate(?float $rebatingRate): self
    {
        $this->initialized['rebatingRate'] = true;
        $this->rebatingRate = $rebatingRate;

        return $this;
    }

    public function getVeterinaryEstablishmentId(): string
    {
        return $this->veterinaryEstablishmentId;
    }

    public function setVeterinaryEstablishmentId(string $veterinaryEstablishmentId): self
    {
        $this->initialized['veterinaryEstablishmentId'] = true;
        $this->veterinaryEstablishmentId = $veterinaryEstablishmentId;

        return $this;
    }

    public function getSupplier(): string
    {
        return $this->supplier;
    }

    public function setSupplier(string $supplier): self
    {
        $this->initialized['supplier'] = true;
        $this->supplier = $supplier;

        return $this;
    }
}
