<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class RequiredMandateRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $billingAccount;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $mandate;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Id - Common Request Model.
     */
    public function getBillingAccount(): IdRequest
    {
        return $this->billingAccount;
    }

    /**
     * Id - Common Request Model.
     */
    public function setBillingAccount(IdRequest $billingAccount): self
    {
        $this->initialized['billingAccount'] = true;
        $this->billingAccount = $billingAccount;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getMandate(): IdRequest
    {
        return $this->mandate;
    }

    /**
     * Id - Common Request Model.
     */
    public function setMandate(IdRequest $mandate): self
    {
        $this->initialized['mandate'] = true;
        $this->mandate = $mandate;

        return $this;
    }
}
