<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ProductPriceResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var \DateTime
     */
    protected $created;

    /**
     * @var \DateTime
     */
    protected $updated;

    /**
     * @var ProductPriceResponseItemAlcyonProduct|null
     */
    protected $alcyonProduct;

    /**
     * @var ProductPriceResponseItemCentravetProduct|null
     */
    protected $centravetProduct;

    /**
     * @var ProductPriceResponseItemCovetoProduct|null
     */
    protected $covetoProduct;

    /**
     * @var string|null
     */
    protected $ean;

    /**
     * @var string|null
     */
    protected $gtin;

    /**
     * @var float|null
     */
    protected $salePriceTaxIncl;

    /**
     * @var string
     */
    protected $remunerationRate;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCreated(): \DateTime
    {
        return $this->created;
    }

    public function setCreated(\DateTime $created): self
    {
        $this->initialized['created'] = true;
        $this->created = $created;

        return $this;
    }

    public function getUpdated(): \DateTime
    {
        return $this->updated;
    }

    public function setUpdated(\DateTime $updated): self
    {
        $this->initialized['updated'] = true;
        $this->updated = $updated;

        return $this;
    }

    public function getAlcyonProduct(): ?ProductPriceResponseItemAlcyonProduct
    {
        return $this->alcyonProduct;
    }

    public function setAlcyonProduct(?ProductPriceResponseItemAlcyonProduct $alcyonProduct): self
    {
        $this->initialized['alcyonProduct'] = true;
        $this->alcyonProduct = $alcyonProduct;

        return $this;
    }

    public function getCentravetProduct(): ?ProductPriceResponseItemCentravetProduct
    {
        return $this->centravetProduct;
    }

    public function setCentravetProduct(?ProductPriceResponseItemCentravetProduct $centravetProduct): self
    {
        $this->initialized['centravetProduct'] = true;
        $this->centravetProduct = $centravetProduct;

        return $this;
    }

    public function getCovetoProduct(): ?ProductPriceResponseItemCovetoProduct
    {
        return $this->covetoProduct;
    }

    public function setCovetoProduct(?ProductPriceResponseItemCovetoProduct $covetoProduct): self
    {
        $this->initialized['covetoProduct'] = true;
        $this->covetoProduct = $covetoProduct;

        return $this;
    }

    public function getEan(): ?string
    {
        return $this->ean;
    }

    public function setEan(?string $ean): self
    {
        $this->initialized['ean'] = true;
        $this->ean = $ean;

        return $this;
    }

    public function getGtin(): ?string
    {
        return $this->gtin;
    }

    public function setGtin(?string $gtin): self
    {
        $this->initialized['gtin'] = true;
        $this->gtin = $gtin;

        return $this;
    }

    public function getSalePriceTaxIncl(): ?float
    {
        return $this->salePriceTaxIncl;
    }

    public function setSalePriceTaxIncl(?float $salePriceTaxIncl): self
    {
        $this->initialized['salePriceTaxIncl'] = true;
        $this->salePriceTaxIncl = $salePriceTaxIncl;

        return $this;
    }

    public function getRemunerationRate(): string
    {
        return $this->remunerationRate;
    }

    public function setRemunerationRate(string $remunerationRate): self
    {
        $this->initialized['remunerationRate'] = true;
        $this->remunerationRate = $remunerationRate;

        return $this;
    }
}
