<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PrincipalPrincipalPut extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $email;

    /**
     * @var string|null
     */
    protected $lastname;

    /**
     * @var string|null
     */
    protected $firstname;

    /**
     * @var string|null
     */
    protected $locale;

    /**
     * @var string|null
     */
    protected $timezone;

    /**
     * @var \DateTime|null
     */
    protected $birthDate;

    /**
     * @var string|null
     */
    protected $birthPostCode;

    /**
     * @var string|null
     */
    protected $birthCity;

    /**
     * @var string|null
     */
    protected $birthCountry;

    /**
     * @var PostalAddress
     */
    protected $mainAddress;

    /**
     * @var list<PrincipalPhoneNumber>
     */
    protected $phoneNumbers;

    /**
     * @var string|null
     */
    protected $mainPhoneNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->initialized['email'] = true;
        $this->email = $email;

        return $this;
    }

    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    public function setLastname(?string $lastname): self
    {
        $this->initialized['lastname'] = true;
        $this->lastname = $lastname;

        return $this;
    }

    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    public function setFirstname(?string $firstname): self
    {
        $this->initialized['firstname'] = true;
        $this->firstname = $firstname;

        return $this;
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }

    public function setLocale(?string $locale): self
    {
        $this->initialized['locale'] = true;
        $this->locale = $locale;

        return $this;
    }

    public function getTimezone(): ?string
    {
        return $this->timezone;
    }

    public function setTimezone(?string $timezone): self
    {
        $this->initialized['timezone'] = true;
        $this->timezone = $timezone;

        return $this;
    }

    public function getBirthDate(): ?\DateTime
    {
        return $this->birthDate;
    }

    public function setBirthDate(?\DateTime $birthDate): self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;

        return $this;
    }

    public function getBirthPostCode(): ?string
    {
        return $this->birthPostCode;
    }

    public function setBirthPostCode(?string $birthPostCode): self
    {
        $this->initialized['birthPostCode'] = true;
        $this->birthPostCode = $birthPostCode;

        return $this;
    }

    public function getBirthCity(): ?string
    {
        return $this->birthCity;
    }

    public function setBirthCity(?string $birthCity): self
    {
        $this->initialized['birthCity'] = true;
        $this->birthCity = $birthCity;

        return $this;
    }

    public function getBirthCountry(): ?string
    {
        return $this->birthCountry;
    }

    public function setBirthCountry(?string $birthCountry): self
    {
        $this->initialized['birthCountry'] = true;
        $this->birthCountry = $birthCountry;

        return $this;
    }

    public function getMainAddress(): PostalAddress
    {
        return $this->mainAddress;
    }

    public function setMainAddress(PostalAddress $mainAddress): self
    {
        $this->initialized['mainAddress'] = true;
        $this->mainAddress = $mainAddress;

        return $this;
    }

    /**
     * @return list<PrincipalPhoneNumber>
     */
    public function getPhoneNumbers(): array
    {
        return $this->phoneNumbers;
    }

    /**
     * @param list<PrincipalPhoneNumber> $phoneNumbers
     */
    public function setPhoneNumbers(array $phoneNumbers): self
    {
        $this->initialized['phoneNumbers'] = true;
        $this->phoneNumbers = $phoneNumbers;

        return $this;
    }

    public function getMainPhoneNumber(): ?string
    {
        return $this->mainPhoneNumber;
    }

    public function setMainPhoneNumber(?string $mainPhoneNumber): self
    {
        $this->initialized['mainPhoneNumber'] = true;
        $this->mainPhoneNumber = $mainPhoneNumber;

        return $this;
    }
}
