<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class Principal extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var PrincipalTypeEnum
     */
    protected $type;

    /**
     * @var string|null
     */
    protected $email;

    /**
     * @var string|null
     */
    protected $lastname;

    /**
     * @var string|null
     */
    protected $firstname;

    /**
     * @var PrincipalStatusEnum
     */
    protected $status;

    /**
     * @var \DateTime|null
     */
    protected $lastLogin;

    /**
     * @var string|null
     */
    protected $locale;

    /**
     * @var string|null
     */
    protected $timezone;

    /**
     * @var \DateTime|null
     */
    protected $birthDate;

    /**
     * @var string|null
     */
    protected $birthPostCode;

    /**
     * @var string|null
     */
    protected $birthCity;

    /**
     * @var CountryTypeEnum|null
     */
    protected $birthCountry;

    /**
     * @var PostalAddress
     */
    protected $mainAddress;

    /**
     * @var \DateTime|null
     */
    protected $privacyPolicyAccepted;

    /**
     * @var list<list<string>>
     */
    protected $phoneNumbers;

    /**
     * @var string|null
     */
    protected $mainPhoneNumber;

    /**
     * @var PrincipalInvitation|null
     */
    protected $invitation;

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $created;

    /**
     * @var \DateTime
     */
    protected $updated;

    /**
     * @var list<PrincipalGroup>
     */
    protected $groups;

    /**
     * @var list<PrincipalInvitation>
     */
    protected $invitationsHosted;

    /**
     * @var string|null
     */
    protected $fullname;

    /**
     * @var bool
     */
    protected $enabled;

    /**
     * @var list<string>
     */
    protected $roles;

    /**
     * @var string|null
     */
    protected $salt;

    /**
     * @var string
     */
    protected $username;

    /**
     * @var string
     */
    protected $userIdentifier;

    /**
     * @var string
     */
    protected $slug;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getType(): PrincipalTypeEnum
    {
        return $this->type;
    }

    public function setType(PrincipalTypeEnum $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->initialized['email'] = true;
        $this->email = $email;

        return $this;
    }

    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    public function setLastname(?string $lastname): self
    {
        $this->initialized['lastname'] = true;
        $this->lastname = $lastname;

        return $this;
    }

    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    public function setFirstname(?string $firstname): self
    {
        $this->initialized['firstname'] = true;
        $this->firstname = $firstname;

        return $this;
    }

    public function getStatus(): PrincipalStatusEnum
    {
        return $this->status;
    }

    public function setStatus(PrincipalStatusEnum $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }

    public function getLastLogin(): ?\DateTime
    {
        return $this->lastLogin;
    }

    public function setLastLogin(?\DateTime $lastLogin): self
    {
        $this->initialized['lastLogin'] = true;
        $this->lastLogin = $lastLogin;

        return $this;
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }

    public function setLocale(?string $locale): self
    {
        $this->initialized['locale'] = true;
        $this->locale = $locale;

        return $this;
    }

    public function getTimezone(): ?string
    {
        return $this->timezone;
    }

    public function setTimezone(?string $timezone): self
    {
        $this->initialized['timezone'] = true;
        $this->timezone = $timezone;

        return $this;
    }

    public function getBirthDate(): ?\DateTime
    {
        return $this->birthDate;
    }

    public function setBirthDate(?\DateTime $birthDate): self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;

        return $this;
    }

    public function getBirthPostCode(): ?string
    {
        return $this->birthPostCode;
    }

    public function setBirthPostCode(?string $birthPostCode): self
    {
        $this->initialized['birthPostCode'] = true;
        $this->birthPostCode = $birthPostCode;

        return $this;
    }

    public function getBirthCity(): ?string
    {
        return $this->birthCity;
    }

    public function setBirthCity(?string $birthCity): self
    {
        $this->initialized['birthCity'] = true;
        $this->birthCity = $birthCity;

        return $this;
    }

    public function getBirthCountry(): ?CountryTypeEnum
    {
        return $this->birthCountry;
    }

    public function setBirthCountry(?CountryTypeEnum $birthCountry): self
    {
        $this->initialized['birthCountry'] = true;
        $this->birthCountry = $birthCountry;

        return $this;
    }

    public function getMainAddress(): PostalAddress
    {
        return $this->mainAddress;
    }

    public function setMainAddress(PostalAddress $mainAddress): self
    {
        $this->initialized['mainAddress'] = true;
        $this->mainAddress = $mainAddress;

        return $this;
    }

    public function getPrivacyPolicyAccepted(): ?\DateTime
    {
        return $this->privacyPolicyAccepted;
    }

    public function setPrivacyPolicyAccepted(?\DateTime $privacyPolicyAccepted): self
    {
        $this->initialized['privacyPolicyAccepted'] = true;
        $this->privacyPolicyAccepted = $privacyPolicyAccepted;

        return $this;
    }

    /**
     * @return list<list<string>>
     */
    public function getPhoneNumbers(): array
    {
        return $this->phoneNumbers;
    }

    /**
     * @param list<list<string>> $phoneNumbers
     */
    public function setPhoneNumbers(array $phoneNumbers): self
    {
        $this->initialized['phoneNumbers'] = true;
        $this->phoneNumbers = $phoneNumbers;

        return $this;
    }

    public function getMainPhoneNumber(): ?string
    {
        return $this->mainPhoneNumber;
    }

    public function setMainPhoneNumber(?string $mainPhoneNumber): self
    {
        $this->initialized['mainPhoneNumber'] = true;
        $this->mainPhoneNumber = $mainPhoneNumber;

        return $this;
    }

    public function getInvitation(): ?PrincipalInvitation
    {
        return $this->invitation;
    }

    public function setInvitation(?PrincipalInvitation $invitation): self
    {
        $this->initialized['invitation'] = true;
        $this->invitation = $invitation;

        return $this;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreated(): \DateTime
    {
        return $this->created;
    }

    public function setCreated(\DateTime $created): self
    {
        $this->initialized['created'] = true;
        $this->created = $created;

        return $this;
    }

    public function getUpdated(): \DateTime
    {
        return $this->updated;
    }

    public function setUpdated(\DateTime $updated): self
    {
        $this->initialized['updated'] = true;
        $this->updated = $updated;

        return $this;
    }

    /**
     * @return list<PrincipalGroup>
     */
    public function getGroups(): array
    {
        return $this->groups;
    }

    /**
     * @param list<PrincipalGroup> $groups
     */
    public function setGroups(array $groups): self
    {
        $this->initialized['groups'] = true;
        $this->groups = $groups;

        return $this;
    }

    /**
     * @return list<PrincipalInvitation>
     */
    public function getInvitationsHosted(): array
    {
        return $this->invitationsHosted;
    }

    /**
     * @param list<PrincipalInvitation> $invitationsHosted
     */
    public function setInvitationsHosted(array $invitationsHosted): self
    {
        $this->initialized['invitationsHosted'] = true;
        $this->invitationsHosted = $invitationsHosted;

        return $this;
    }

    public function getFullname(): ?string
    {
        return $this->fullname;
    }

    public function setFullname(?string $fullname): self
    {
        $this->initialized['fullname'] = true;
        $this->fullname = $fullname;

        return $this;
    }

    public function getEnabled(): bool
    {
        return $this->enabled;
    }

    public function setEnabled(bool $enabled): self
    {
        $this->initialized['enabled'] = true;
        $this->enabled = $enabled;

        return $this;
    }

    /**
     * @return list<string>
     */
    public function getRoles(): array
    {
        return $this->roles;
    }

    /**
     * @param list<string> $roles
     */
    public function setRoles(array $roles): self
    {
        $this->initialized['roles'] = true;
        $this->roles = $roles;

        return $this;
    }

    public function getSalt(): ?string
    {
        return $this->salt;
    }

    public function setSalt(?string $salt): self
    {
        $this->initialized['salt'] = true;
        $this->salt = $salt;

        return $this;
    }

    public function getUsername(): string
    {
        return $this->username;
    }

    public function setUsername(string $username): self
    {
        $this->initialized['username'] = true;
        $this->username = $username;

        return $this;
    }

    public function getUserIdentifier(): string
    {
        return $this->userIdentifier;
    }

    public function setUserIdentifier(string $userIdentifier): self
    {
        $this->initialized['userIdentifier'] = true;
        $this->userIdentifier = $userIdentifier;

        return $this;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function setSlug(string $slug): self
    {
        $this->initialized['slug'] = true;
        $this->slug = $slug;

        return $this;
    }
}
