<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class InvoiceResponseAccountingMovement extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $incrementalNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getIncrementalNumber(): string
    {
        return $this->incrementalNumber;
    }

    public function setIncrementalNumber(string $incrementalNumber): self
    {
        $this->initialized['incrementalNumber'] = true;
        $this->incrementalNumber = $incrementalNumber;

        return $this;
    }
}
