<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class InvoiceAddressResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $addressSupplement;

    /**
     * @var string
     */
    protected $city;

    /**
     * @var string
     */
    protected $country;

    /**
     * @var string
     */
    protected $identityName;

    /**
     * @var string
     */
    protected $postalCode;

    /**
     * @var string|null
     */
    protected $postBoxNumber;

    /**
     * @var string
     */
    protected $streetName;

    /**
     * @var string|null
     */
    protected $streetNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAddressSupplement(): ?string
    {
        return $this->addressSupplement;
    }

    public function setAddressSupplement(?string $addressSupplement): self
    {
        $this->initialized['addressSupplement'] = true;
        $this->addressSupplement = $addressSupplement;

        return $this;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function setCity(string $city): self
    {
        $this->initialized['city'] = true;
        $this->city = $city;

        return $this;
    }

    public function getCountry(): string
    {
        return $this->country;
    }

    public function setCountry(string $country): self
    {
        $this->initialized['country'] = true;
        $this->country = $country;

        return $this;
    }

    public function getIdentityName(): string
    {
        return $this->identityName;
    }

    public function setIdentityName(string $identityName): self
    {
        $this->initialized['identityName'] = true;
        $this->identityName = $identityName;

        return $this;
    }

    public function getPostalCode(): string
    {
        return $this->postalCode;
    }

    public function setPostalCode(string $postalCode): self
    {
        $this->initialized['postalCode'] = true;
        $this->postalCode = $postalCode;

        return $this;
    }

    public function getPostBoxNumber(): ?string
    {
        return $this->postBoxNumber;
    }

    public function setPostBoxNumber(?string $postBoxNumber): self
    {
        $this->initialized['postBoxNumber'] = true;
        $this->postBoxNumber = $postBoxNumber;

        return $this;
    }

    public function getStreetName(): string
    {
        return $this->streetName;
    }

    public function setStreetName(string $streetName): self
    {
        $this->initialized['streetName'] = true;
        $this->streetName = $streetName;

        return $this;
    }

    public function getStreetNumber(): ?string
    {
        return $this->streetNumber;
    }

    public function setStreetNumber(?string $streetNumber): self
    {
        $this->initialized['streetNumber'] = true;
        $this->streetNumber = $streetNumber;

        return $this;
    }
}
