<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class InvitationResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var \DateTime|null
     */
    protected $expirationDate;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $hostUser;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $invitedUser;

    /**
     * @var string
     */
    protected $status;

    /**
     * @var string
     */
    protected $type;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getExpirationDate(): ?\DateTime
    {
        return $this->expirationDate;
    }

    public function setExpirationDate(?\DateTime $expirationDate): self
    {
        $this->initialized['expirationDate'] = true;
        $this->expirationDate = $expirationDate;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getHostUser(): ?NullableIdResponse
    {
        return $this->hostUser;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setHostUser(?NullableIdResponse $hostUser): self
    {
        $this->initialized['hostUser'] = true;
        $this->hostUser = $hostUser;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getInvitedUser(): ?NullableIdResponse
    {
        return $this->invitedUser;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setInvitedUser(?NullableIdResponse $invitedUser): self
    {
        $this->initialized['invitedUser'] = true;
        $this->invitedUser = $invitedUser;

        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }
}
