<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class CreditNoteBankTransferResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * Credit Note Category.
     *
     * @var string
     */
    protected $category;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var list<IdResponse>
     */
    protected $creditNotes;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * Credit Note Category.
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * Credit Note Category.
     */
    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    /**
     * @return list<IdResponse>
     */
    public function getCreditNotes(): array
    {
        return $this->creditNotes;
    }

    /**
     * @param list<IdResponse> $creditNotes
     */
    public function setCreditNotes(array $creditNotes): self
    {
        $this->initialized['creditNotes'] = true;
        $this->creditNotes = $creditNotes;

        return $this;
    }
}
