<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class Client extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $slug;

    /**
     * @var string
     */
    protected $randomId;

    /**
     * @var string
     */
    protected $secret;

    /**
     * @var list<string>
     */
    protected $redirectUris;

    /**
     * @var list<string>
     */
    protected $allowedGrantTypes;

    /**
     * @var string|null
     */
    protected $serviceUser;

    /**
     * @var int|null
     */
    protected $accessTokenLifetime;

    /**
     * @var int|null
     */
    protected $refreshTokenLifetime;

    /**
     * @var string|null
     */
    protected $id;

    /**
     * @var \DateTime|null
     */
    protected $created;

    /**
     * @var \DateTime|null
     */
    protected $updated;

    /**
     * Liste de clients dont les permissions sont également listées par l'IAM.
     *
     * @var list<string>
     */
    protected $clientsAccessPerms;

    /**
     * @var string
     */
    protected $publicId;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function setSlug(string $slug): self
    {
        $this->initialized['slug'] = true;
        $this->slug = $slug;

        return $this;
    }

    public function getRandomId(): string
    {
        return $this->randomId;
    }

    public function setRandomId(string $randomId): self
    {
        $this->initialized['randomId'] = true;
        $this->randomId = $randomId;

        return $this;
    }

    public function getSecret(): string
    {
        return $this->secret;
    }

    public function setSecret(string $secret): self
    {
        $this->initialized['secret'] = true;
        $this->secret = $secret;

        return $this;
    }

    /**
     * @return list<string>
     */
    public function getRedirectUris(): array
    {
        return $this->redirectUris;
    }

    /**
     * @param list<string> $redirectUris
     */
    public function setRedirectUris(array $redirectUris): self
    {
        $this->initialized['redirectUris'] = true;
        $this->redirectUris = $redirectUris;

        return $this;
    }

    /**
     * @return list<string>
     */
    public function getAllowedGrantTypes(): array
    {
        return $this->allowedGrantTypes;
    }

    /**
     * @param list<string> $allowedGrantTypes
     */
    public function setAllowedGrantTypes(array $allowedGrantTypes): self
    {
        $this->initialized['allowedGrantTypes'] = true;
        $this->allowedGrantTypes = $allowedGrantTypes;

        return $this;
    }

    public function getServiceUser(): ?string
    {
        return $this->serviceUser;
    }

    public function setServiceUser(?string $serviceUser): self
    {
        $this->initialized['serviceUser'] = true;
        $this->serviceUser = $serviceUser;

        return $this;
    }

    public function getAccessTokenLifetime(): ?int
    {
        return $this->accessTokenLifetime;
    }

    public function setAccessTokenLifetime(?int $accessTokenLifetime): self
    {
        $this->initialized['accessTokenLifetime'] = true;
        $this->accessTokenLifetime = $accessTokenLifetime;

        return $this;
    }

    public function getRefreshTokenLifetime(): ?int
    {
        return $this->refreshTokenLifetime;
    }

    public function setRefreshTokenLifetime(?int $refreshTokenLifetime): self
    {
        $this->initialized['refreshTokenLifetime'] = true;
        $this->refreshTokenLifetime = $refreshTokenLifetime;

        return $this;
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(?string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreated(): ?\DateTime
    {
        return $this->created;
    }

    public function setCreated(?\DateTime $created): self
    {
        $this->initialized['created'] = true;
        $this->created = $created;

        return $this;
    }

    public function getUpdated(): ?\DateTime
    {
        return $this->updated;
    }

    public function setUpdated(?\DateTime $updated): self
    {
        $this->initialized['updated'] = true;
        $this->updated = $updated;

        return $this;
    }

    /**
     * Liste de clients dont les permissions sont également listées par l'IAM.
     *
     * @return list<string>
     */
    public function getClientsAccessPerms(): array
    {
        return $this->clientsAccessPerms;
    }

    /**
     * Liste de clients dont les permissions sont également listées par l'IAM.
     *
     * @param list<string> $clientsAccessPerms
     */
    public function setClientsAccessPerms(array $clientsAccessPerms): self
    {
        $this->initialized['clientsAccessPerms'] = true;
        $this->clientsAccessPerms = $clientsAccessPerms;

        return $this;
    }

    public function getPublicId(): string
    {
        return $this->publicId;
    }

    public function setPublicId(string $publicId): self
    {
        $this->initialized['publicId'] = true;
        $this->publicId = $publicId;

        return $this;
    }
}
