<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class BillingAccountRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $bicSwift;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $file;

    /**
     * @var string|null
     */
    protected $iban;

    /**
     * @var string
     */
    protected $identityName;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $legalStructure;

    /**
     * @var string
     */
    protected $status;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getBicSwift(): ?string
    {
        return $this->bicSwift;
    }

    public function setBicSwift(?string $bicSwift): self
    {
        $this->initialized['bicSwift'] = true;
        $this->bicSwift = $bicSwift;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getFile(): ?NullableIdRequest
    {
        return $this->file;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setFile(?NullableIdRequest $file): self
    {
        $this->initialized['file'] = true;
        $this->file = $file;

        return $this;
    }

    public function getIban(): ?string
    {
        return $this->iban;
    }

    public function setIban(?string $iban): self
    {
        $this->initialized['iban'] = true;
        $this->iban = $iban;

        return $this;
    }

    public function getIdentityName(): string
    {
        return $this->identityName;
    }

    public function setIdentityName(string $identityName): self
    {
        $this->initialized['identityName'] = true;
        $this->identityName = $identityName;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getLegalStructure(): IdRequest
    {
        return $this->legalStructure;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLegalStructure(IdRequest $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }
}
