<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class Tokeninfo extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    protected $token;

    /**
     * Retrieve token info from token.
     *
     * @param string $token The token
     */
    public function __construct(string $token)
    {
        $this->token = $token;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return \str_replace(['{token}'], [$this->token], '/oauth/v2/token_info/{token}');
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\OauthV2TokenInfoTokenGetResponse200
     *
     * @throws \NoahVet\Reef\Jane\Exception\TokeninfoUnauthorizedException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\OauthV2TokenInfoTokenGetResponse200', 'json');
        }
        if ((null === $contentType) === false && (401 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            throw new \NoahVet\Reef\Jane\Exception\TokeninfoUnauthorizedException($serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\OauthV2TokenInfoTokenGetResponse401', 'json'), $response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
