<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetTmpVeterinaryEstablishmentFreeInvoice extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    protected $a;

    /**
     * Get Tmp Veterinary Establishment Free Invoice.
     *
     * @param string $a the dynamic name
     */
    public function __construct(string $a)
    {
        $this->a = $a;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return \str_replace(['{a}'], [$this->a], '/tmp/veterinary_establishment_free_invoices/{a}');
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    /**
     * @return null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetTmpVeterinaryEstablishmentFreeInvoiceBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetTmpVeterinaryEstablishmentFreeInvoiceNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetTmpVeterinaryEstablishmentFreeInvoiceBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetTmpVeterinaryEstablishmentFreeInvoiceNotFoundException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
