<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetAllProductPrice extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * List Product Prices.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $alcyonProductCode[] Filter by alcyonProductCode
     * @var array  $centravetProductCode[] Filter by centravetProductCode
     * @var array  $covetoProductCode[] Filter by covetoProductCode
     * @var array  $ean[] Filter by ean
     * @var array  $gtin[] Filter by gtin
     * @var array  $psProductAttributeId[] Filter by ps_product_attribute_id
     * @var array  $fromCreated[] Filter from created
     * @var array  $fromUpdated[] Filter from updated
     * @var array  $toCreated[] Filter to created
     * @var array  $toUpdated[] Filter to updated
     * @var string $sortCreated sort by created
     * @var string $sortUpdated Sort by updated.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/api/v1/product_prices';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'alcyonProductCode', 'centravetProductCode', 'covetoProductCode', 'ean', 'gtin', 'psProductAttributeId', 'fromCreated', 'fromUpdated', 'toCreated', 'toUpdated', 'sortCreated', 'sortUpdated']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('alcyonProductCode', ['array']);
        $optionsResolver->addAllowedTypes('centravetProductCode', ['array']);
        $optionsResolver->addAllowedTypes('covetoProductCode', ['array']);
        $optionsResolver->addAllowedTypes('ean', ['array']);
        $optionsResolver->addAllowedTypes('gtin', ['array']);
        $optionsResolver->addAllowedTypes('psProductAttributeId', ['array']);
        $optionsResolver->addAllowedTypes('fromCreated', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdated', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreated', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdated', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreated', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdated', ['string']);

        return $optionsResolver;
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\ProductPriceResponseItem[]
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllProductPriceBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetAllProductPriceInternalServerErrorException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\ProductPriceResponseItem[]', 'json');
        }
        if ((null === $contentType) === false && (206 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\ProductPriceResponseItem[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAllProductPriceBadRequestException($response);
        }
        if (500 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAllProductPriceInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
