<?php

declare(strict_types=1);

namespace NoahVet\Reef\Iterator\Factory;

use NoahVet\Reef\Iterator\ReefApiIteratorInterface;
use NoahVet\Reef\Jane\Runtime\Client\Endpoint;

interface ReefApiIteratorFactoryInterface
{
    /**
     * @template TValue of object
     *
     * @param class-string<Endpoint> $endpoint
     * @param class-string<TValue>   $responseClass
     * @param array<string, mixed>   $params
     *
     * @return ReefApiIteratorInterface<TValue, array<string, mixed>>
     */
    public function create(
        object $client,
        string $endpoint,
        string $responseClass,
        array $params = [],
        int $querySize = 50,
        ?string $chunkProperty = null,
    ): ReefApiIteratorInterface;
}
