<?php

declare(strict_types=1);

namespace NoahVet\Reef\File\Dumper\Yaml;

use Symfony\Component\Yaml\Yaml;

final class Dumper implements DumperInterface
{
    #[\Override]
    public function dumpContent(array $content): string
    {
        return Yaml::dump(
            $content,
            32,
            2,
            Yaml::PARSE_CONSTANT,
        );
    }
}
