<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use Symfony\Component\HttpFoundation\Request;

class SortingApplier extends AbstractApplier implements SortingApplierInterface
{
    /**
     * @return array<string, mixed>
     */
    public function apply(Request $request, array $whitelist): array
    {
        $allowedSortingKeys = \array_flip($whitelist['sorting']);

        /** @var array<string, scalar> $sortingKeys */
        $sortingKeys = \array_filter(
            $request->query->all(),
            fn ($queryParam) => \str_starts_with($queryParam, 'sort') && \array_key_exists($queryParam, $allowedSortingKeys),
            \ARRAY_FILTER_USE_KEY,
        );

        return $sortingKeys;
    }
}
