<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use Symfony\Component\HttpFoundation\Request;

/**
 * @psalm-import-type WhitelistShape from \NoahVet\Reef\Factory\RequestContext\ApplierInterface
 *
 * @psalm-type RequestContext = array{permissions: mixed, filters: mixed, sorting: mixed, keywords: mixed}
 */
interface RequestContextFactoryInterface
{
    /**
     * @param WhitelistShape $whitelist
     *
     * @return RequestContext
     */
    public function createContextFromRequest(Request $request, array $whitelist): array;
}
