<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use Symfony\Component\HttpFoundation\Request;

/**
 * @psalm-type WhitelistShape = array{
 *     filters: list<mixed>,
 *     keywords?: list<mixed>|string,
 *     pagination: array{page?: int, limit?: int},
 *     permissions?: list<
 *         array{mappedKey: string, permissionSlug: string|list<string>, resourceName: string}
 *     >,
 *     sorting: list<mixed>
 *     }
 */
interface ApplierInterface
{
    /**
     * @param WhitelistShape $whitelist
     */
    public function apply(Request $request, array $whitelist): mixed;
}
