<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\Jane;

use NoahVet\Reef\Jane\Runtime\Client\Endpoint;

class EndpointFactory implements EndpointFactoryInterface
{
    /**
     * @template TEndpoint of Endpoint
     *
     * @param class-string<TEndpoint> $endpointClass
     * @param array<string, mixed>    $queryParams
     *
     * @return TEndpoint
     */
    public function create(string $endpointClass, array $queryParams): Endpoint
    {
        return new $endpointClass($queryParams);
    }
}
