<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

interface StringToolInterface extends ToolInterface
{
    public const CHAR_LIST_WITH_ACCENT = 'àáâãäçèéêëìíîïñòóôõöùúûüýÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ';
    public const LOWER_CASE_LIST_WITH_ACCENT = 'aaaaaceeeeiiiinooooouuuuy';
    public const UPPER_CASE_LIST_WITH_ACCENT = 'AAAAACEEEEIIIINOOOOOUUUUY';
    public const SUPPORTED_SEPARATORS = [' ', '-', "'"];

    /**
     * Before.
     *
     * hello-world
     *
     * After
     *
     * hello_world
     */
    public static function fromBurgerCaseToSnakeCase(string $subject): string;

    /**
     * Before.
     *
     * hello_world
     *
     * After
     *
     * hello-world
     */
    public static function fromSnakeCaseToBurgerCase(string $subject): string;

    /**
     * Before.
     *
     * Hello World
     *
     * After
     *
     * hello-world
     */
    public static function fromSpacedToBurgerCase(string $subject): string;

    /**
     * Before.
     *
     * Hello World
     *
     * After
     *
     * HELLO-WORLD
     */
    public static function fromSpacedToUpperBurgerCase(string $subject): string;

    /**
     * Before.
     *
     * HelloWorld
     *
     * After
     *
     * helloWorld
     */
    public static function fromPascalCaseToCamelCase(string $subject): string;

    /**
     * Before.
     *
     * A MAJ CHAIN
     *
     * After
     *
     * A Maj Chain
     */
    public static function fromSpacedToPascalCase(string $subject): string;

    /**
     * Before.
     *
     * ' Hello WORLD '
     *
     * After
     *
     * 'HELLO_WORLD'
     */
    public static function fromSpacedToSnakeUpperCase(string $subject): string;

    /**
     * Before.
     *
     * ' héllo WORLD '
     *
     * After
     *
     * 'hello WORLD'
     */
    public static function toLowerCaseWithoutAccent(string $subject): string;

    /**
     * Before.
     *
     * ' hÉllo WORLD '
     *
     * After
     *
     * 'hEllo WORLD'
     */
    public static function toUpperCaseWithoutAccent(string $subject): string;

    /**
     * Before.
     *
     * ' HéÉllo WORLD '
     *
     * After
     *
     * 'HeEllo WORLD'
     */
    public static function removeAccent(string $subject): string;

    /**
     * Before.
     *
     * ' Hello WORLD '
     *
     * After
     *
     * 'HelloWORLD'
     */
    public static function removeWhitespace(string $subject): string;

    /**
     *  Before.
     *
     * ' HeLlo worlD '.
     *
     *  After
     *
     *  'Hello World'
     *
     * @param array<string> $supportedSeparators
     */
    public static function toName(string $name, array $supportedSeparators = self::SUPPORTED_SEPARATORS): string;

    /**
     *  Before.
     *
     *  ' helloWorld '.
     *
     *  After
     *
     *  'HelloWorld'
     */
    public static function toPascalCase(string $subject): string;

    /**
     *  Before.
     *
     *  ' helloWorld '.
     *
     *  After
     *
     *  'hello-world'
     */
    public static function fromCamelCaseToBurgerCase(string $subject): string;
}
