<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

final class OpenAPITool implements OpenAPIToolInterface
{
    #[\Override]
    public function cleanParameters(array $content): array
    {
        $parameters = [];

        foreach ($content['parameters'] as $parameter) {
            if (isset($parameter['in']) && 'query' == $parameter['in']) {
                $cleanParameterName = \str_replace('[', '', $parameter['name']);
                $cleanParameterName = \str_replace(']', '', $cleanParameterName);
                $parameters['parameters'][] = $cleanParameterName;
            }
        }

        return $parameters;
    }

    #[\Override]
    public function cleanUri(string $uri): string
    {
        return \str_replace(
            '}',
            '',
            \str_replace(
                '{',
                '',
                $uri),
        );
    }
}
