<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Service\Enum;

use NoahVet\Reef\Domain\Common\EnumTrait;
use NoahVet\Reef\Domain\Common\StringEnumInterface;

enum VeterinaryServiceOptionCodeEnum: string implements StringEnumInterface
{
    use EnumTrait;

    case ARCHIVE = 'ARCHIVE';
    case CE_TRAINING = 'CE-FORM';

    // Club Avantage
    case CE_SUBSCRIPTION = 'CE-ABO';
    case CE_GRP_SUBSCRIPTION = 'CE-GRP-ABO';
    case CE_WALLET = 'CE-CAGN';

    // Crokit
    case CROKIT_PREMIUM = 'CRKT-ABO';
    case CROKIT_FREEMIUM = 'CRKT-FREEMIUM';

    // MyVetShop
    case MVS_SUBSCRIPTION = 'MVS-ABO';

    // Negotiation
    case NEGOTIATION_ALIMENTATION = 'NGO-AM';
    case NEGOTIATION_ALIMENTATION_DPE = 'NGO-DPE';

    // Planning Veto
    case PLANNING_VETO_APPOINTMENT = 'PV-RDV';

    // VetoPartner
    case VP_TRAINING = 'VP-FORM';
    case VP_MAINTENANCE = 'VP-MAINT';
    case VP_MAINTENANCE_DPE = 'VP-MAINT-DPE';
    case VP_MIGRATION = 'VP-TR';
    case VP_SUBSCRIPTION = 'VP-ABO';
    case VP_SUBSCRIPTION_DPE = 'VP-DPE';
}
