<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Invoice\Enum;

use NoahVet\Reef\Domain\Common\EnumTrait;
use NoahVet\Reef\Domain\Common\StringEnumInterface;

enum CreditNoteCategoryEnum: string implements CreditNoteCategoryEnumInterface, StringEnumInterface
{
    use EnumTrait;

    case ALIM = 'ALIM';
    case CREDIT_NOTE = 'CREDIT_NOTE';
    case OTHER = 'OTHER';
    case SELF_BILLING = 'SELF_BILLING';

    public function isSelfBilling(): bool
    {
        return match ($this) {
            self::SELF_BILLING => true,
            default => false,
        };
    }
}
