<?php

declare(strict_types=1);

namespace NoahVet\Reef\Command\OpenAPI;

use NoahVet\Reef\Domain\Tool\FileTool;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Yaml\Yaml;

abstract class AbstractDumpCommand extends Command implements DumpCommandInterface
{
    protected string $sourceFilePath;

    protected string $destinationDirectory;

    public function writeFile(
        string $filePath,
        string $fileData,
    ): void {
        FileTool::forceFilePutContents($filePath, $fileData);
    }

    public function resolvePath(
        string $uri,
        string $httpMethod,
        string $type,
    ): string {
        return \sprintf(
            '%s%s/%s/%s.yaml',
            $this->destinationDirectory,
            $uri,
            $httpMethod,
            $type,
        );
    }

    /**
     * @return array<string, mixed>
     */
    protected function preExecute(): array
    {
        // Delete all files in destination directory
        FileTool::forceRemoveDirectory($this->destinationDirectory);

        return Yaml::parseFile($this->sourceFilePath);
    }
}
