<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model\Factory;

use NoahVet\Reef\Business\Model\TeamMember;
use NoahVet\Reef\Jane\Model\ManufacturerUserResponseItem;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponse;
use NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponse;

class TeamMemberFactory
{
    public function create(
        VeterinaryEstablishmentUserResponse
        |VeterinaryGroupUserResponse
        |ManufacturerUserResponseItem $teamMember,
    ): TeamMember {
        $userId = $teamMember->getUser()?->getId();

        if (null === $userId) {
            throw new \LogicException();
        }

        $entryDate = $teamMember->getEntryDate();
        $exitDate = $teamMember->getExitDate();

        return new TeamMember(
            $userId,
            $teamMember->getJobTitle(),
            $entryDate ? \DateTimeImmutable::createFromMutable($entryDate) : null,
            $exitDate ? \DateTimeImmutable::createFromMutable($exitDate) : null,
        );
    }
}
