<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Enumerator;

use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentBadRequestException;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponse;

class VeterinaryEstablishmentEnumerator
{
    public function __construct(
        protected Client $client,
    ) {
    }

    /**
     * @param array{
     *     isRegularized?: bool,
     *     veuJobTitle?: string[],
     *     id?: string[],
     *     veuUserId?: string[],
     *     name?: string[],
     *     privilegedCode?: string[],
     *     type?: string[],
     *     tag?: string[],
     *     fromCreatedDate?: string[],
     *     fromUpdatedDate?: string[],
     *     toCreatedDate?: string[],
     *     toUpdatedDate?: string[],
     *     sortCreatedDate?: string,
     *     sortEntryNumber?: string,
     *     sortName?: string,
     *     sortPrivilegedCode?: string,
     *     sortType?: string,
     *     sortUpdatedDate?: string,
     * } $filters
     *
     * @return \Generator<VeterinaryEstablishmentResponse>
     *
     * @see Client::getAllVeterinaryEstablishment()
     */
    public function enumerateAll(array $filters = [], int $querySize = 50): \Generator
    {
        for ($page = 0; true; ++$page) {
            try {
                $establishments = $this->client->getAllVeterinaryEstablishment(
                    \array_merge($filters, ['page' => $page, 'limit' => $querySize]),
                );

                \assert(\is_array($establishments));

                foreach ($establishments as $establishment) {
                    yield $establishment;
                }

                if (\count($establishments) < $querySize) {
                    break;
                }
            } catch (GetAllVeterinaryEstablishmentBadRequestException) {
                // End of enumeration
                break;
            }
        }
    }
}
