<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Phpunit\Fixture;

use NoahVet\Reef\Phpunit\Fixture\FixtureRepository;
use NoahVet\Reef\Phpunit\Fixture\ReefTokenFixture;
use NoahVet\Reef\Security\User\ReefOAuthUser;
use PHPUnit\Framework\TestCase;

class FixtureRepositoryTest extends TestCase
{
    public function testAddFixture(): void
    {
        $repository = new FixtureRepository();
        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            null,
        );
        $repository->addFixture($tokenFixture);

        self::assertSame(
            $tokenFixture,
            $repository->findByOAuthToken('unit_token'),
        );
        self::assertNull(
            $repository->findByOAuthToken('unkown_token'),
        );
    }

    public function testSetFixtures(): void
    {
        $repository = new FixtureRepository();

        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            null,
        );
        $repository->setFixtures([$tokenFixture]);
        self::assertSame(
            $tokenFixture,
            $repository->findByOAuthToken('unit_token'),
        );
        self::assertNull(
            $repository->findByOAuthToken('unkown_token'),
        );

        $repository->setFixtures([]);
        self::assertNull(
            $repository->findByOAuthToken('unit_token'),
        );
        self::assertNull(
            $repository->findByOAuthToken('unkown_token'),
        );
    }

    public function testFindByUser(): void
    {
        $repository = new FixtureRepository();
        $user = new ReefOAuthUser('iuserid');
        $unkownUser = new ReefOAuthUser('iuserid_unkown');

        $tokenFixture = new ReefTokenFixture(
            'unit_token',
            $user,
        );
        $repository->setFixtures([$tokenFixture]);
        self::assertSame(
            $tokenFixture,
            $repository->findByUser($user),
        );
        self::assertNull(
            $repository->findByUser($unkownUser),
        );

        $repository->setFixtures([]);
        self::assertNull(
            $repository->findByUser($user),
        );
        self::assertNull(
            $repository->findByUser($unkownUser),
        );
    }
}
