<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Iterator;

use NoahVet\Reef\Iterator\ApiClientChunkedReefIteratorDecorator;
use NoahVet\Reef\Iterator\ReefApiIteratorInterface;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class ApiClientChunkedReefIteratorDecoratorTest extends TestCase
{
    /**
     * @var ReefApiIteratorInterface&MockObject
     */
    private ReefApiIteratorInterface $iterator;

    protected function setUp(): void
    {
        $this->iterator = $this->createMock(ReefApiIteratorInterface::class);
    }

    public function testOneChunk(): void
    {
        $arrayIterator = new \ArrayIterator([new \stdClass(), new \stdClass()]);

        $this->iterator
            ->method('getParams')
            ->willReturn(['id' => [1, 2, 3, 4]])
        ;

        $invokedSetParamsCount = self::exactly(2);
        $this->iterator
            ->expects($invokedSetParamsCount)
            ->method('setParams')
            ->willReturnCallback(function (array $params) use ($invokedSetParamsCount, $arrayIterator): void {
                if (1 === $invokedSetParamsCount->getInvocationCount()) {
                    $this->assertSame(['id' => [1, 2]], $params);
                }

                if (2 === $invokedSetParamsCount->getInvocationCount()) {
                    $this->assertSame(['id' => [3, 4]], $params);
                }

                $arrayIterator->rewind();
            })
        ;

        $this->iterator
            ->method('next')
            ->willReturnCallback(fn () => $arrayIterator->next())
        ;

        $this->iterator
            ->method('key')
            ->willReturnCallback(fn () => $arrayIterator->key())
        ;

        $this->iterator
            ->method('current')
            ->willReturnCallback(fn () => $arrayIterator->current())
        ;

        $this->iterator
            ->method('valid')
            ->willReturnCallback(fn () => $arrayIterator->valid())
        ;

        $decorator = new ApiClientChunkedReefIteratorDecorator($this->iterator, 'id', 2);

        $result = \iterator_to_array($decorator);

        $this->assertCount(4, $result);
    }
}
