<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Log;

use NoahVet\Reef\Domain\Log\StringSanitizer;
use PHPUnit\Framework\TestCase;

class StringSanitizerTest extends TestCase
{
    public function testSanitize(): void
    {
        $sanitized = StringSanitizer::sanitize('test');
        self::assertSame('test', $sanitized);

        $sanitized = StringSanitizer::sanitize('test with "quotes"');
        self::assertSame('test with quotes', $sanitized);

        $sanitized = StringSanitizer::sanitize('test with [array]');
        self::assertSame('test with array', $sanitized);
    }
}
