<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Http\Header;

use NoahVet\Reef\Domain\Exception\InvalidContentRangeException;
use NoahVet\Reef\Domain\Http\Header\ContentRangeHttpHeader;
use PHPUnit\Framework\TestCase;

class ContentRangeHttpHeaderTest extends TestCase
{
    public function testParseValidHeader(): void
    {
        $header = 'bytes 0-499/1234';
        $expected = [
            'unit' => 'bytes',
            'rangeStart' => 0,
            'rangeEnd' => 499,
            'size' => 1234,
        ];

        $result = ContentRangeHttpHeader::parse($header);

        $this->assertEquals($expected, $result);
    }

    public function testParseAnotherValidHeader(): void
    {
        $header = 'bytes 200-300/1000';
        $expected = [
            'unit' => 'bytes',
            'rangeStart' => 200,
            'rangeEnd' => 300,
            'size' => 1000,
        ];

        $result = ContentRangeHttpHeader::parse($header);

        $this->assertEquals($expected, $result);
    }

    public function testParseInvalidHeaderThrowsException(): void
    {
        $this->expectException(InvalidContentRangeException::class);

        $invalidHeader = 'invalid-content-range';
        ContentRangeHttpHeader::parse($invalidHeader);
    }

    public function testParseHeaderMissingSizeThrowsException(): void
    {
        $this->expectException(InvalidContentRangeException::class);

        $invalidHeader = 'bytes 0-499/';
        ContentRangeHttpHeader::parse($invalidHeader);
    }

    public function testParseHeaderInvalidRangeFormatThrowsException(): void
    {
        $this->expectException(InvalidContentRangeException::class);

        $invalidHeader = 'bytes 0-499-1000';
        ContentRangeHttpHeader::parse($invalidHeader);
    }

    public function testParseHeaderNonNumericValuesThrowsException(): void
    {
        $this->expectException(InvalidContentRangeException::class);

        $invalidHeader = 'bytes start-end/size';
        ContentRangeHttpHeader::parse($invalidHeader);
    }
}
