<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\TokenExchange;

use NoahVet\Reef\Security\Token\JWTDecoderInterface;
use Psr\Cache\CacheItemPoolInterface;

class CachedTokenExchangerFactory
{
    public function __construct(
        private readonly CacheItemPoolInterface $cache,
        private readonly DirectTokenExchanger $directTokenExchanger,
        private readonly JWTDecoderInterface $JWTDecoder,
        private readonly string $reefClientId,
    ) {
    }

    public function createCachedTokenExchanger(): TokenExchangerInterface
    {
        return new CachedTokenExchangerDecorator(
            $this->cache,
            $this->JWTDecoder,
            $this->reefClientId,
            $this->directTokenExchanger,
        );
    }
}
