<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Mapper;

use NoahVet\Reef\Security\IAM\Model\Resource;
use NoahVet\Reef\Security\User\ReefOAuthUser;

class ReefOAuthUserMapper implements InternalResourceMapperInterface
{
    public function canMap(mixed $entity): bool
    {
        return $entity instanceof ReefOAuthUser;
    }

    public function mapResource(mixed $entity): Resource
    {
        \assert($entity instanceof ReefOAuthUser);

        return Resource::fromString('reef:iam:principal', $entity->getUserIdentifier());
    }
}
