<?php

declare(strict_types=1);

namespace NoahVet\Reef\Repository;

use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ObjectRepository;

/**
 * @template EntityType of object
 *
 * @extends ObjectRepository<EntityType>
 */
interface BaseRepositoryInterface extends ObjectRepository
{
    public function countOnId(?QueryBuilder $qb = null): int;

    /**
     * @return array<int, EntityType>
     */
    public function findPaginated(int $page, int $limit, ?QueryBuilder $qb = null): array;

    /**
     * @return array<int, EntityType>
     */
    public function findAllResult(?QueryBuilder $qb = null): array;

    /**
     * @param array<string, array<int, mixed>> $permissions
     * @param array<string, array<int, mixed>> $filters
     * @param array<string, string>            $sorting
     */
    public function prepareQuery(
        array $permissions = [],
        array $filters = [],
        array $sorting = [],
        string $keywords = '',
        ?QueryBuilder $qb = null,
    ): QueryBuilder;

    /**
     * @return BaseRepositoryInterface<EntityType>
     */
    public function setLocale(string $locale): self;

    /**
     * If the values are "ids", they must be converted to binary so that Doctrine can compare values correctly.
     *
     * @param array<int, mixed> $nativeFilterValue
     *
     * @return array<int, mixed>
     */
    public function convertUuidFilterValues(string $nativeFilterKey, array $nativeFilterValue): array;
}
