<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Executor\Factory;

use NoahVet\Reef\Factory\Process\ProcessFactoryInterface;
use NoahVet\Reef\RabbitMQ\Task\Executor\ConsoleCommandTaskExecutorInterface;
use NoahVet\Reef\RabbitMQ\Task\Executor\DirectConsoleTaskCommandExecutor;
use NoahVet\Reef\RabbitMQ\Task\Executor\NewProcessConsoleTaskCommandExecutor;

class ConsoleCommandTaskExecutorFactoryFactory implements ConsoleCommandTaskExecutorFactoryInterface
{
    public function __construct(
        private ProcessFactoryInterface $processFactory,
    ) {
    }

    public function createConsoleCommandTaskExecutor(): ConsoleCommandTaskExecutorInterface
    {
        if (\class_exists('Symfony\Component\Process\Process')) {
            return new NewProcessConsoleTaskCommandExecutor($this->processFactory);
        }

        return new DirectConsoleTaskCommandExecutor();
    }
}
