<?php

declare(strict_types=1);

namespace NoahVet\Reef\Phpunit\RabbitMQ\Producer\Factory;

use NoahVet\Reef\Phpunit\RabbitMQ\Producer\MockedMQProducer;
use NoahVet\Reef\RabbitMQ\Producer\Factory\ReefMQProducerFactoryInterface;
use NoahVet\Reef\RabbitMQ\Producer\ReefMQProducerInterface;

class MockedMQProducerFactory implements ReefMQProducerFactoryInterface
{
    private ?MockedMQProducer $mockedMQProducer = null;

    public function getProducer(): ReefMQProducerInterface
    {
        if (null === $this->mockedMQProducer) {
            $this->mockedMQProducer = new MockedMQProducer();
        }

        return $this->mockedMQProducer;
    }
}
