<?php

declare(strict_types=1);

namespace NoahVet\Reef\Phpunit\Log;

use NoahVet\Reef\Domain\Log\SyslogMessage;
use NoahVet\Reef\Log\SyslogClientInterface;

class MockedSyslogClient implements SyslogClientInterface
{
    /**
     * @var list<SyslogMessage>
     */
    protected array $messages = [];

    /**
     * @return list<SyslogMessage>
     */
    public function getMessages(): array
    {
        return $this->messages;
    }

    public function sendMessage(SyslogMessage $syslogMessage): void
    {
        $this->messages[] = $syslogMessage;
    }
}
