<?php

declare(strict_types=1);

namespace NoahVet\Reef\Phpunit\Fixture;

use NoahVet\Reef\Security\IAM\Model\Resource;
use NoahVet\Reef\Security\IAM\Model\ResourceGroupWithMembers;
use NoahVet\Reef\Security\IAM\Model\ResourceType;

class PermissionFixture
{
    /**
     * @param string[] $allowedPermission
     */
    public function __construct(
        protected Resource|ResourceGroupWithMembers $target,
        protected array $allowedPermission,
    ) {
    }

    public function getTarget(): ResourceGroupWithMembers|Resource
    {
        return $this->target;
    }

    public function getResourceType(): ResourceType
    {
        return $this->target->getResourceType();
    }

    public function getTargetSlug(): string
    {
        return $this->target->getSlug();
    }

    /**
     * @return string[]
     */
    public function getAllowedPermission(): array
    {
        return $this->allowedPermission;
    }
}
