<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\One\Update;

use NoahVet\Reef\Mapper\Common\One\AbstractOneMapperInterface;

/**
 * @template EntityType of object
 * @template RequestDtoType of object
 *
 * @extends AbstractOneMapperInterface<EntityType>
 */
interface AbstractUpdateMapperInterface extends AbstractOneMapperInterface
{
    /**
     * @param class-string<RequestDtoType> $requestDto
     * @param EntityType                   $existingEntity
     *
     * @return RequestDtoType
     */
    public function mapDataToRequestDto(
        string $data,
        string $requestDto,
        object $existingEntity,
    ): object;

    /**
     * @param RequestDtoType $requestDto
     *
     * @return EntityType
     */
    public function mapRequestDtoToEntity(
        object $requestDto,
    ): object;

    /**
     * @param EntityType $entity
     *
     * @return array<string, mixed>
     */
    public function normalizeExistingEntity(
        object $entity,
    ): array;
}
