<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\One\Create;

use NoahVet\Reef\Mapper\Common\One\AbstractOneMapperInterface;

/**
 * @template EntityType of object
 * @template RequestDtoType of object
 * @template ResponseDtoType of object
 *
 * @extends AbstractOneMapperInterface<EntityType>
 */
interface AbstractCreateMapperInterface extends AbstractOneMapperInterface
{
    /**
     * @param class-string<RequestDtoType> $requestDto
     *
     * @return RequestDtoType
     */
    public function mapDataToRequestDto(
        string $data,
        string $requestDto,
    ): object;

    /**
     * @param RequestDtoType $requestDto
     *
     * @return EntityType
     */
    public function mapRequestDtoToEntity(
        object $requestDto,
    ): object;
}
