<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\Many;

use Doctrine\Common\Collections\Collection;

/**
 * @template EntityType of object
 * @template ResponseDtoType of object
 */
interface AbstractGetAllMapperInterface
{
    /**
     * @param array<int, EntityType>        $data
     * @param class-string<ResponseDtoType> $responseDtoFqcn
     *
     * @return list<ResponseDtoType>
     */
    public function mapDataToResponseDto(
        array $data,
        string $responseDtoFqcn,
    ): mixed;

    /**
     * @param list<ResponseDtoType> $dtoAsArray
     *
     * @return list<mixed>
     */
    public function normalizeResponseDto(
        array $dtoAsArray,
    ): array;

    /**
     * @param Collection<int, EntityType> $entities
     *
     * @return list<mixed>
     */
    public function normalizeEntities(
        Collection $entities,
    ): array;
}
