<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentUserInvitationRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('departments', $data) && null !== $data['departments']) {
            $values = [];
            foreach ($data['departments'] as $value) {
                $values[] = $value;
            }
            $object->setDepartments($values);
            unset($data['departments']);
        } elseif (\array_key_exists('departments', $data) && null === $data['departments']) {
            $object->setDepartments(null);
        }
        if (\array_key_exists('emailTemplateNumber', $data)) {
            $object->setEmailTemplateNumber($data['emailTemplateNumber']);
            unset($data['emailTemplateNumber']);
        }
        if (\array_key_exists('expirationDate', $data) && null !== $data['expirationDate']) {
            $object->setExpirationDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['expirationDate']));
            unset($data['expirationDate']);
        } elseif (\array_key_exists('expirationDate', $data) && null === $data['expirationDate']) {
            $object->setExpirationDate(null);
        }
        if (\array_key_exists('entryDate', $data)) {
            $object->setEntryDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['entryDate']));
            unset($data['entryDate']);
        }
        if (\array_key_exists('exitDate', $data) && null !== $data['exitDate']) {
            $object->setExitDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['exitDate']));
            unset($data['exitDate']);
        } elseif (\array_key_exists('exitDate', $data) && null === $data['exitDate']) {
            $object->setExitDate(null);
        }
        if (\array_key_exists('invitedUser', $data)) {
            $object->setInvitedUser($this->denormalizer->denormalize($data['invitedUser'], \NoahVet\Reef\Jane\Model\IdRequest::class, 'json', $context));
            unset($data['invitedUser']);
        }
        if (\array_key_exists('jobTitle', $data)) {
            $object->setJobTitle($data['jobTitle']);
            unset($data['jobTitle']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Jane\Model\IdRequest::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('departments') && null !== $data->getDepartments()) {
            $values = [];
            foreach ($data->getDepartments() as $value) {
                $values[] = $value;
            }
            $dataArray['departments'] = $values;
        }
        $dataArray['emailTemplateNumber'] = $data->getEmailTemplateNumber();
        if ($data->isInitialized('expirationDate') && null !== $data->getExpirationDate()) {
            $dataArray['expirationDate'] = $data->getExpirationDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('entryDate') && null !== $data->getEntryDate()) {
            $dataArray['entryDate'] = $data->getEntryDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('exitDate') && null !== $data->getExitDate()) {
            $dataArray['exitDate'] = $data->getExitDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('invitedUser') && null !== $data->getInvitedUser()) {
            $dataArray['invitedUser'] = $this->normalizer->normalize($data->getInvitedUser(), 'json', $context);
        }
        $dataArray['jobTitle'] = $data->getJobTitle();
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationRequest::class => false];
    }
}
