<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1PetPublicProfilesIdPatchBodyNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBody::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBody::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBody();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d', $data['birthDate'])->setTime(0, 0, 0));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('freePetBreed', $data) && null !== $data['freePetBreed']) {
            $object->setFreePetBreed($data['freePetBreed']);
            unset($data['freePetBreed']);
        } elseif (\array_key_exists('freePetBreed', $data) && null === $data['freePetBreed']) {
            $object->setFreePetBreed(null);
        }
        if (\array_key_exists('gender', $data) && null !== $data['gender']) {
            $object->setGender($data['gender']);
            unset($data['gender']);
        } elseif (\array_key_exists('gender', $data) && null === $data['gender']) {
            $object->setGender(null);
        }
        if (\array_key_exists('name', $data) && null !== $data['name']) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && null === $data['name']) {
            $object->setName(null);
        }
        if (\array_key_exists('petBreed', $data) && null !== $data['petBreed']) {
            $object->setPetBreed($this->denormalizer->denormalize($data['petBreed'], \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBodyPetBreed::class, 'json', $context));
            unset($data['petBreed']);
        } elseif (\array_key_exists('petBreed', $data) && null === $data['petBreed']) {
            $object->setPetBreed(null);
        }
        if (\array_key_exists('profilePicture', $data) && null !== $data['profilePicture']) {
            $object->setProfilePicture($this->denormalizer->denormalize($data['profilePicture'], \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBodyProfilePicture::class, 'json', $context));
            unset($data['profilePicture']);
        } elseif (\array_key_exists('profilePicture', $data) && null === $data['profilePicture']) {
            $object->setProfilePicture(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('birthDate') && null !== $data->getBirthDate()) {
            $dataArray['birthDate'] = $data->getBirthDate()->format('Y-m-d');
        }
        if ($data->isInitialized('freePetBreed') && null !== $data->getFreePetBreed()) {
            $dataArray['freePetBreed'] = $data->getFreePetBreed();
        }
        if ($data->isInitialized('gender') && null !== $data->getGender()) {
            $dataArray['gender'] = $data->getGender();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('petBreed') && null !== $data->getPetBreed()) {
            $dataArray['petBreed'] = $this->normalizer->normalize($data->getPetBreed(), 'json', $context);
        }
        if ($data->isInitialized('profilePicture') && null !== $data->getProfilePicture()) {
            $dataArray['profilePicture'] = $this->normalizer->normalize($data->getProfilePicture(), 'json', $context);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchBody::class => false];
    }
}
