<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class YousignSignatureRequestResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $signatureRequestId;

    /**
     * @var \DateTime
     */
    protected $signatureLink;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getSignatureRequestId(): string
    {
        return $this->signatureRequestId;
    }

    public function setSignatureRequestId(string $signatureRequestId): self
    {
        $this->initialized['signatureRequestId'] = true;
        $this->signatureRequestId = $signatureRequestId;

        return $this;
    }

    public function getSignatureLink(): \DateTime
    {
        return $this->signatureLink;
    }

    public function setSignatureLink(\DateTime $signatureLink): self
    {
        $this->initialized['signatureLink'] = true;
        $this->signatureLink = $signatureLink;

        return $this;
    }
}
