<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentUserInvitationResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var list<string>
     */
    protected $departments;

    /**
     * @var int
     */
    protected $emailTemplateNumber;

    /**
     * @var \DateTime|null
     */
    protected $expirationDate;

    /**
     * @var \DateTime
     */
    protected $entryDate;

    /**
     * @var \DateTime|null
     */
    protected $exitDate;

    /**
     * @var string
     */
    protected $jobTitle;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $invitedUser;

    /**
     * @var string
     */
    protected $status;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * @return list<string>
     */
    public function getDepartments(): array
    {
        return $this->departments;
    }

    /**
     * @param list<string> $departments
     */
    public function setDepartments(array $departments): self
    {
        $this->initialized['departments'] = true;
        $this->departments = $departments;

        return $this;
    }

    public function getEmailTemplateNumber(): int
    {
        return $this->emailTemplateNumber;
    }

    public function setEmailTemplateNumber(int $emailTemplateNumber): self
    {
        $this->initialized['emailTemplateNumber'] = true;
        $this->emailTemplateNumber = $emailTemplateNumber;

        return $this;
    }

    public function getExpirationDate(): ?\DateTime
    {
        return $this->expirationDate;
    }

    public function setExpirationDate(?\DateTime $expirationDate): self
    {
        $this->initialized['expirationDate'] = true;
        $this->expirationDate = $expirationDate;

        return $this;
    }

    public function getEntryDate(): \DateTime
    {
        return $this->entryDate;
    }

    public function setEntryDate(\DateTime $entryDate): self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;

        return $this;
    }

    public function getExitDate(): ?\DateTime
    {
        return $this->exitDate;
    }

    public function setExitDate(?\DateTime $exitDate): self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;

        return $this;
    }

    public function getJobTitle(): string
    {
        return $this->jobTitle;
    }

    public function setJobTitle(string $jobTitle): self
    {
        $this->initialized['jobTitle'] = true;
        $this->jobTitle = $jobTitle;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getInvitedUser(): IdResponse
    {
        return $this->invitedUser;
    }

    /**
     * Id - Response Model.
     */
    public function setInvitedUser(IdResponse $invitedUser): self
    {
        $this->initialized['invitedUser'] = true;
        $this->invitedUser = $invitedUser;

        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishment(): IdResponse
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishment(IdResponse $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
